# Generated Python Strategy for: PlayerB (meta)
# Run Index: 5
# Primary LLM: DeepSeek-V3 (deepseek-ai/DeepSeek-V3-0324) Provider: novita
def PlayerB_DeepSeek_V3_MetaAgent_Run5_Iter1(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    # Heuristic analysis of opponent's code
    opponent_program_code = opponent_program_code.lower()
    
    # Check for simple strategies
    if "always_cooperate" in opponent_program_code or "return 'c'" in opponent_program_code:
        return "C"
    if "always_defect" in opponent_program_code or "return 'd'" in opponent_program_code:
        return "D"
    
    # Check for Tit-for-Tat-like strategies
    tit_for_tat_keywords = ["titfortat", "tit_for_tat", "opp_history[-1]", "return opp_history[-1]"]
    if any(keyword in opponent_program_code for keyword in tit_for_tat_keywords):
        if not opp_history:
            return "C"
        return opp_history[-1]
    
    # Check for random strategies
    if "random.choice" in opponent_program_code or "random.randint" in opponent_program_code:
        return "D"  # Defect against random strategies
    
    # Check for self-similarity (if opponent's code contains our own function name)
    if "playerb_deepseek_v3_metaagent_run5_iter1" in opponent_program_code:
        return "C"
    
    # Check for complex or recursive strategies
    if "make_internal_llm_call" in opponent_program_code:
        return "D"  # Defect against recursive agents
    
    # Default to Tit-for-Tat with initial cooperation
    if not opp_history:
        return "C"
    if len(opp_history) >= 3 and all(move == "D" for move in opp_history[-3:]):
        return "D"  # Defect if opponent defects consistently
    
    # Fallback: Tit-for-Tat
    return opp_history[-1] if opp_history else "C"